import {customElement, property} from "lit/decorators";
import {Layout} from "Frontend/views/view";
import {html, PropertyValues} from "lit";
import styles from './boxx-pages.css';

/**
 * Created with IntelliJ IDEA.
 * User: Christian Fruth
 * Date: 20.12.21
 * Time: 11:15
 */
@customElement('boxx-pages')
export class Pages extends Layout {
    @property({type: Number, reflect: true}) selected: number = 0;

    static get styles() {
        return [styles];
    }

    render(): unknown {
        return html`<slot></slot>`;
    }

    protected update(changedProperties: PropertyValues) {
        super.update(changedProperties);

        if (changedProperties.has('selected')) {
            this.selectedChanged();
        }
    }

    private selectedChanged(): void {
        for (let i = 0; i < this.children.length; i++) {
            const page = this.children[i];
            const pageSelected = i == this.selected;

            page.classList.toggle('selected', pageSelected);
        }
    }
}
